// SSoundStream.h
// Copyright © 1997-98 Olivier Wittenberg
// All Rights Reserved.

#pragma once

// Big-endian everywhere
// Linear sampling everywhere
// 8 bits or 16 bits sampling
// mono or stereo


class SSoundStream
{
public:
						SSoundStream() : stream_name(NULL) {}
virtual					~SSoundStream();

        const char		*Name() { return stream_name ? stream_name : "no name"; }

virtual	int32			SamplingRate() const = 0;
virtual	int32			CountChannels() const = 0;
virtual	int32			FrameSize() const = 0;
virtual	off_t			CountFrames() const = 0;

virtual	ssize_t			ReadFrames(uint8 *, size_t) = 0;
virtual	ssize_t			WriteFrames(uint8 *, size_t) = 0;
virtual	off_t			SeekToFrame(off_t) = 0;

virtual	off_t			FrameIndex() const = 0;
virtual	off_t			FramesRemaining() const = 0;

virtual	int32			SetSamplingRate(int32) = 0;

		// Streams are clonable, thus thread-safe
virtual	SSoundStream	*Clone() = 0;

		// The following two methods are specific to the file stream
virtual	void			SetReadingAhead(bool) {}
virtual	void			SwitchToReadMode() {}

protected:
        void            SetName(const char *);

private:
		char			*stream_name;
};